"use client"
import Image from 'next/image'
import axios from 'axios'
import { useEffect, useState } from 'react';
import parse from 'html-react-parser';
import Link from 'next/link'
import Footer from '../components/footer'
import Header from '../components/header'
import '../globals.css'
import 'bootstrap/dist/css/bootstrap.css'
import { useParams } from 'next/navigation'
import Loader from '../components/loader';
import Head from 'next/head'
import { useRouter } from 'next/router';




const Home = ()=>{
  const router = useRouter();
const [data,setData]=useState()
const [hasSlider,setHasSlider]=useState(false)
const [loaded,setLoaded]= useState(false)
const params = useParams()
async function getData(params) {
  if (params?.page) {
    const dataResponse = await axios.get('https://pixelfcty.com/api/pages?populate=deep&filters[slug][$eq]='+params.page)
    const data = dataResponse.data.data[0]
    if (!data) {
      router.push('/404')
    }
    setData(data)
    if (data) {
      if (data.attributes.slider.length!==0) {
        setHasSlider(true)
      } else setHasSlider(false)
    }
  }
}
  useEffect(() => { 
    getData(params)
    setTimeout(() => {
      setLoaded(true)
      console.log('ffff');
      document.querySelectorAll('a').forEach(e=>{
        if (!e.href.includes('aljaberholding.com') && e.href.includes('https://') ) {
            console.log(e)
          e.target = '_blank'
        }
      })
    }, 1000);
    
  }, [params])

  async function sendform() {
    
    let name = document.querySelector('.name').value
    let email = document.querySelector('.email').value
    let description = document.querySelector('.description').value
    let mobile = document.querySelector('.mobile').value
    let gender = document.querySelector('.gender').value
    let birthday = document.querySelector('.birthday').value
    let country = document.querySelector('.country').value
    let nationality = document.querySelector('.nationality').value
    let city = document.querySelector('.city').value
    // let file = document.querySelector('.cv').files[0]
    // let form = new FormData()
    // form.append('files',file)
    // console.log(form);
  //   const fileResponse = await axios.post('https://pixelfcty.com/api/upload',{data:{
  //     form
  // }})
  // console.log(fileResponse);
    const dataResponse = await axios.post('https://pixelfcty.com/api/careers',{data:{
      name,
      email,
      description,
      mobile,
      birthday,
      gender,
      country,
      nationality,
      city
    }})
    alert('thanks for sending document, we will send message to you soon.')
    document.querySelector('.name').value = ''
    document.querySelector('.email').value = ''
    document.querySelector('.description').value = ''
    document.querySelector('.mobile').value = ''
    document.querySelector('.gender').value = ''
    document.querySelector('.birthday').value = ''
    document.querySelector('.country').value = ''
    document.querySelector('.nationality').value = ''
    document.querySelector('.city').value = ''
  }

  async function sendformContact() {
    
    let name = document.querySelector('.name').value
    let email = document.querySelector('.email').value
    let description = document.querySelector('.description').value
    const dataResponse = await axios.post('https://pixelfcty.com/api/contacts',{data:{
      name,
      email,
      description,
      company:params.company
    }})
    alert('thanks for sending document, we will send message to you soon.')
    document.querySelector('.name').value = ''
    document.querySelector('.email').value = ''
    document.querySelector('.description').value = ''
  }
  return (
    <>
        <Head>
      <title>Aljaber Holding |  {data?.attributes.title}</title>
    </Head>
    {!loaded?

      <Loader></Loader>
  :
    <main >
      <Header iswhite={hasSlider}/>
      <div className="container-fluid p-0 m-0 overflow-hidden">
        <div className="row ">
          <div className="col-sm-12 header-video">
            <div id="carouselExampleIndicators" className="carousel slide">
            <div className="carousel-indicators">

              {data?
              data['attributes']['slider']?
                data['attributes']['slider'].map((e,index)=>(
                  <button key={e.id} type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to={index} className="active" aria-current="true" aria-label="Slide 1"></button>
                ))
                :'':''
              }
              </div>
              <div className="carousel-inner">
                
              {data?
              data['attributes']['slider']?
                data['attributes']['slider'].map((e,index)=>(
                  <div key={e.id} className={`carousel-item ${index==0?'active':''}`}>
                  <video src={'https://pixelfcty.com/'+e['media']['data']['attributes']['url']}   muted autoPlay preload='true' loop className="d-block w-100">
                    Your browser does not support the video tag.
                  </video>    
                  </div>                ))
                :'':''
              }


              </div>
              <button className="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
                <span className="carousel-control-prev-icon" aria-hidden="true"></span>
                <span className="visually-hidden">Previous</span>
              </button>
              <button className="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
                <span className="carousel-control-next-icon" aria-hidden="true"></span>
                <span className="visually-hidden">Next</span>
              </button>
            </div>

          </div>
        </div>
      </div>
      <div className="container pt-10 pb-10">
        <div className="row  ">
          <div className="col-md-12 ck-content">
            {data && data['attributes']['body'] ?
              parse(data['attributes']['body'])
              : ''
            }

            {data && data['attributes']['slug'] ?
              data['attributes']['carrier']?

              <div className='career'>
              <h3>Career</h3>
              <input type="text" name='name' className='name' placeholder='Name' />
              <input type="date" name="birthday" id="" className='birthday' />
              <select name="gender" className='gender' id="">
                <option value="male">Male</option>
                <option value="female">Female</option>
              </select>
              <input type="text" name='nationality' className='nationality' placeholder='Nationality' />
              <input type="text" name='country' className='country' placeholder='Country' />
              <input type="text" name='city' className='city' placeholder='City' />
              <input type="text" name='mobile' className='mobile' placeholder='Mobile' />
              <input type="email" name='email' className='email' placeholder='Email' />
              <textarea type="text" name='description' className='description' placeholder='Description'></textarea>
              <input type="file" name="cv" id="" className='cv' />
              <input onClick={sendform} type="submit" value="Send" className='careerSend' />
              </div>
              :''
              : ''
            }

{data && data['attributes']['slug'] ?
              data['attributes']['contact']?

              <div className='career'>
              <h3>for any inquiries please contact us</h3>
              <input type="text" name='name' className='name' placeholder='Name' />
              <input type="email" name='email' className='email' placeholder='Email' />
              <textarea type="text" name='description' className='description' placeholder='Description'></textarea>
              <input onClick={sendformContact} type="submit" value="Send" className='careerSend' />
              </div>
              :''
              : ''
            }
          </div>
        </div>
      </div>

          <Footer/>
    </main>
          }
          </>
  )
}




export default Home;